package ontologias.frutasOntology;


import jade.content.onto.*;
import jade.content.schema.*;

 
public class frutasOntology extends Ontology {
   // Nombre de la ontologa
   public static final String ONTOLOGY_NAME = "ontologa de frutas";
 
  // Vocabulario de la ontologa que van a manejar los agentes
  public static final String FRUTA = "Fruta";
  public static final String FRUTA_NOMBRE = "nombre";
  public static final String FRUTA_PRECIO = "precio";
 
  public static final String OFERTA = "Oferta";
  public static final String OFERTA_FRUTA = "fruta";
 
  public static final String COMPRAR = "Comprar";
  public static final String COMPRAR_FRUTA = "fruta";
 
  // Instancia de la ontologa (que ser nica)
  private static Ontology instancia = new frutasOntology();
 
  // Mtodo para acceder a la instancia de la ontologa
  public static Ontology getInstance() {
     return instancia;
   }
 
   // Constructor privado
   private frutasOntology() {
     // frutasOntology extiende la ontologa bsica
     super(ONTOLOGY_NAME, BasicOntology.getInstance());
     
     try {
       // Aade los elementos
       add(new AgentActionSchema(COMPRAR), Comprar.class);
       add(new ConceptSchema(FRUTA), Fruta.class);
       add(new PredicateSchema(OFERTA), Oferta.class);

 
       // Estructura del esquema para el concepto FRUTA
       ConceptSchema cs = (ConceptSchema) getSchema(FRUTA);
       cs.add(FRUTA_NOMBRE, (PrimitiveSchema) getSchema(BasicOntology.STRING));
       cs.add(FRUTA_PRECIO, (PrimitiveSchema) getSchema(BasicOntology.INTEGER));
 
       // Estructura del esquema para el predicado OFERTA
       PredicateSchema ps = (PredicateSchema) getSchema(OFERTA);
       ps.add(OFERTA_FRUTA, (ConceptSchema) getSchema(FRUTA));
 
       // Estructura del esquema para la accin COMPRAR
       AgentActionSchema as = (AgentActionSchema) getSchema(COMPRAR);
       as.add(COMPRAR_FRUTA, (ConceptSchema) getSchema(FRUTA));
     }
     catch (OntologyException oe) {
       oe.printStackTrace();
     }
   }
}
 